import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  DisassociateSubnetCidrBlockRequest,
  DisassociateSubnetCidrBlockResult,
} from "../models/models_5";
export interface DisassociateSubnetCidrBlockCommandInput
  extends DisassociateSubnetCidrBlockRequest {}
export interface DisassociateSubnetCidrBlockCommandOutput
  extends DisassociateSubnetCidrBlockResult,
    __MetadataBearer {}
export declare class DisassociateSubnetCidrBlockCommand extends $Command<
  DisassociateSubnetCidrBlockCommandInput,
  DisassociateSubnetCidrBlockCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: DisassociateSubnetCidrBlockCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: DisassociateSubnetCidrBlockCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    DisassociateSubnetCidrBlockCommandInput,
    DisassociateSubnetCidrBlockCommandOutput
  >;
  private serialize;
  private deserialize;
}
