import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  DescribeVpnConnectionsRequest,
  DescribeVpnConnectionsResult,
} from "../models/models_5";
export interface DescribeVpnConnectionsCommandInput
  extends DescribeVpnConnectionsRequest {}
export interface DescribeVpnConnectionsCommandOutput
  extends DescribeVpnConnectionsResult,
    __MetadataBearer {}
export declare class DescribeVpnConnectionsCommand extends $Command<
  DescribeVpnConnectionsCommandInput,
  DescribeVpnConnectionsCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: DescribeVpnConnectionsCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: DescribeVpnConnectionsCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    DescribeVpnConnectionsCommandInput,
    DescribeVpnConnectionsCommandOutput
  >;
  private serialize;
  private deserialize;
}
