import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  DescribeVolumeAttributeRequest,
  DescribeVolumeAttributeResult,
} from "../models/models_4";
export interface DescribeVolumeAttributeCommandInput
  extends DescribeVolumeAttributeRequest {}
export interface DescribeVolumeAttributeCommandOutput
  extends DescribeVolumeAttributeResult,
    __MetadataBearer {}
export declare class DescribeVolumeAttributeCommand extends $Command<
  DescribeVolumeAttributeCommandInput,
  DescribeVolumeAttributeCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: DescribeVolumeAttributeCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: DescribeVolumeAttributeCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    DescribeVolumeAttributeCommandInput,
    DescribeVolumeAttributeCommandOutput
  >;
  private serialize;
  private deserialize;
}
