import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  DescribeVerifiedAccessInstancesRequest,
  DescribeVerifiedAccessInstancesResult,
} from "../models/models_4";
export interface DescribeVerifiedAccessInstancesCommandInput
  extends DescribeVerifiedAccessInstancesRequest {}
export interface DescribeVerifiedAccessInstancesCommandOutput
  extends DescribeVerifiedAccessInstancesResult,
    __MetadataBearer {}
export declare class DescribeVerifiedAccessInstancesCommand extends $Command<
  DescribeVerifiedAccessInstancesCommandInput,
  DescribeVerifiedAccessInstancesCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: DescribeVerifiedAccessInstancesCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: DescribeVerifiedAccessInstancesCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    DescribeVerifiedAccessInstancesCommandInput,
    DescribeVerifiedAccessInstancesCommandOutput
  >;
  private serialize;
  private deserialize;
}
