import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  DescribeVerifiedAccessEndpointsRequest,
  DescribeVerifiedAccessEndpointsResult,
} from "../models/models_4";
export interface DescribeVerifiedAccessEndpointsCommandInput
  extends DescribeVerifiedAccessEndpointsRequest {}
export interface DescribeVerifiedAccessEndpointsCommandOutput
  extends DescribeVerifiedAccessEndpointsResult,
    __MetadataBearer {}
export declare class DescribeVerifiedAccessEndpointsCommand extends $Command<
  DescribeVerifiedAccessEndpointsCommandInput,
  DescribeVerifiedAccessEndpointsCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: DescribeVerifiedAccessEndpointsCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: DescribeVerifiedAccessEndpointsCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    DescribeVerifiedAccessEndpointsCommandInput,
    DescribeVerifiedAccessEndpointsCommandOutput
  >;
  private serialize;
  private deserialize;
}
