import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  DescribeSpotPriceHistoryRequest,
  DescribeSpotPriceHistoryResult,
} from "../models/models_4";
export interface DescribeSpotPriceHistoryCommandInput
  extends DescribeSpotPriceHistoryRequest {}
export interface DescribeSpotPriceHistoryCommandOutput
  extends DescribeSpotPriceHistoryResult,
    __MetadataBearer {}
export declare class DescribeSpotPriceHistoryCommand extends $Command<
  DescribeSpotPriceHistoryCommandInput,
  DescribeSpotPriceHistoryCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: DescribeSpotPriceHistoryCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: DescribeSpotPriceHistoryCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    DescribeSpotPriceHistoryCommandInput,
    DescribeSpotPriceHistoryCommandOutput
  >;
  private serialize;
  private deserialize;
}
