import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  DescribeSpotFleetInstancesRequest,
  DescribeSpotFleetInstancesResponse,
} from "../models/models_4";
export interface DescribeSpotFleetInstancesCommandInput
  extends DescribeSpotFleetInstancesRequest {}
export interface DescribeSpotFleetInstancesCommandOutput
  extends DescribeSpotFleetInstancesResponse,
    __MetadataBearer {}
export declare class DescribeSpotFleetInstancesCommand extends $Command<
  DescribeSpotFleetInstancesCommandInput,
  DescribeSpotFleetInstancesCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: DescribeSpotFleetInstancesCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: DescribeSpotFleetInstancesCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    DescribeSpotFleetInstancesCommandInput,
    DescribeSpotFleetInstancesCommandOutput
  >;
  private serialize;
  private deserialize;
}
