import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  DescribeReservedInstancesListingsRequest,
  DescribeReservedInstancesListingsResult,
} from "../models/models_4";
export interface DescribeReservedInstancesListingsCommandInput
  extends DescribeReservedInstancesListingsRequest {}
export interface DescribeReservedInstancesListingsCommandOutput
  extends DescribeReservedInstancesListingsResult,
    __MetadataBearer {}
export declare class DescribeReservedInstancesListingsCommand extends $Command<
  DescribeReservedInstancesListingsCommandInput,
  DescribeReservedInstancesListingsCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: DescribeReservedInstancesListingsCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: DescribeReservedInstancesListingsCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    DescribeReservedInstancesListingsCommandInput,
    DescribeReservedInstancesListingsCommandOutput
  >;
  private serialize;
  private deserialize;
}
