import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  DescribePlacementGroupsRequest,
  DescribePlacementGroupsResult,
} from "../models/models_4";
export interface DescribePlacementGroupsCommandInput
  extends DescribePlacementGroupsRequest {}
export interface DescribePlacementGroupsCommandOutput
  extends DescribePlacementGroupsResult,
    __MetadataBearer {}
export declare class DescribePlacementGroupsCommand extends $Command<
  DescribePlacementGroupsCommandInput,
  DescribePlacementGroupsCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: DescribePlacementGroupsCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: DescribePlacementGroupsCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    DescribePlacementGroupsCommandInput,
    DescribePlacementGroupsCommandOutput
  >;
  private serialize;
  private deserialize;
}
