import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  DescribeNetworkInterfacePermissionsRequest,
  DescribeNetworkInterfacePermissionsResult,
} from "../models/models_4";
export interface DescribeNetworkInterfacePermissionsCommandInput
  extends DescribeNetworkInterfacePermissionsRequest {}
export interface DescribeNetworkInterfacePermissionsCommandOutput
  extends DescribeNetworkInterfacePermissionsResult,
    __MetadataBearer {}
export declare class DescribeNetworkInterfacePermissionsCommand extends $Command<
  DescribeNetworkInterfacePermissionsCommandInput,
  DescribeNetworkInterfacePermissionsCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: DescribeNetworkInterfacePermissionsCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: DescribeNetworkInterfacePermissionsCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    DescribeNetworkInterfacePermissionsCommandInput,
    DescribeNetworkInterfacePermissionsCommandOutput
  >;
  private serialize;
  private deserialize;
}
