import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  DescribeNetworkInterfaceAttributeRequest,
  DescribeNetworkInterfaceAttributeResult,
} from "../models/models_4";
export interface DescribeNetworkInterfaceAttributeCommandInput
  extends DescribeNetworkInterfaceAttributeRequest {}
export interface DescribeNetworkInterfaceAttributeCommandOutput
  extends DescribeNetworkInterfaceAttributeResult,
    __MetadataBearer {}
export declare class DescribeNetworkInterfaceAttributeCommand extends $Command<
  DescribeNetworkInterfaceAttributeCommandInput,
  DescribeNetworkInterfaceAttributeCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: DescribeNetworkInterfaceAttributeCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: DescribeNetworkInterfaceAttributeCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    DescribeNetworkInterfaceAttributeCommandInput,
    DescribeNetworkInterfaceAttributeCommandOutput
  >;
  private serialize;
  private deserialize;
}
