import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  DescribeManagedPrefixListsRequest,
  DescribeManagedPrefixListsResult,
} from "../models/models_4";
export interface DescribeManagedPrefixListsCommandInput
  extends DescribeManagedPrefixListsRequest {}
export interface DescribeManagedPrefixListsCommandOutput
  extends DescribeManagedPrefixListsResult,
    __MetadataBearer {}
export declare class DescribeManagedPrefixListsCommand extends $Command<
  DescribeManagedPrefixListsCommandInput,
  DescribeManagedPrefixListsCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: DescribeManagedPrefixListsCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: DescribeManagedPrefixListsCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    DescribeManagedPrefixListsCommandInput,
    DescribeManagedPrefixListsCommandOutput
  >;
  private serialize;
  private deserialize;
}
