import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  DescribeLocalGatewayVirtualInterfaceGroupsRequest,
  DescribeLocalGatewayVirtualInterfaceGroupsResult,
} from "../models/models_4";
export interface DescribeLocalGatewayVirtualInterfaceGroupsCommandInput
  extends DescribeLocalGatewayVirtualInterfaceGroupsRequest {}
export interface DescribeLocalGatewayVirtualInterfaceGroupsCommandOutput
  extends DescribeLocalGatewayVirtualInterfaceGroupsResult,
    __MetadataBearer {}
export declare class DescribeLocalGatewayVirtualInterfaceGroupsCommand extends $Command<
  DescribeLocalGatewayVirtualInterfaceGroupsCommandInput,
  DescribeLocalGatewayVirtualInterfaceGroupsCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: DescribeLocalGatewayVirtualInterfaceGroupsCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: DescribeLocalGatewayVirtualInterfaceGroupsCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    DescribeLocalGatewayVirtualInterfaceGroupsCommandInput,
    DescribeLocalGatewayVirtualInterfaceGroupsCommandOutput
  >;
  private serialize;
  private deserialize;
}
