import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import { DescribeIpamsRequest, DescribeIpamsResult } from "../models/models_4";
export interface DescribeIpamsCommandInput extends DescribeIpamsRequest {}
export interface DescribeIpamsCommandOutput
  extends DescribeIpamsResult,
    __MetadataBearer {}
export declare class DescribeIpamsCommand extends $Command<
  DescribeIpamsCommandInput,
  DescribeIpamsCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: DescribeIpamsCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: DescribeIpamsCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<DescribeIpamsCommandInput, DescribeIpamsCommandOutput>;
  private serialize;
  private deserialize;
}
