import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  DescribeIpamPoolsRequest,
  DescribeIpamPoolsResult,
} from "../models/models_4";
export interface DescribeIpamPoolsCommandInput
  extends DescribeIpamPoolsRequest {}
export interface DescribeIpamPoolsCommandOutput
  extends DescribeIpamPoolsResult,
    __MetadataBearer {}
export declare class DescribeIpamPoolsCommand extends $Command<
  DescribeIpamPoolsCommandInput,
  DescribeIpamPoolsCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: DescribeIpamPoolsCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: DescribeIpamPoolsCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<DescribeIpamPoolsCommandInput, DescribeIpamPoolsCommandOutput>;
  private serialize;
  private deserialize;
}
