import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import { DescribeInstanceTypesRequest } from "../models/models_3";
import { DescribeInstanceTypesResult } from "../models/models_4";
export interface DescribeInstanceTypesCommandInput
  extends DescribeInstanceTypesRequest {}
export interface DescribeInstanceTypesCommandOutput
  extends DescribeInstanceTypesResult,
    __MetadataBearer {}
export declare class DescribeInstanceTypesCommand extends $Command<
  DescribeInstanceTypesCommandInput,
  DescribeInstanceTypesCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: DescribeInstanceTypesCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: DescribeInstanceTypesCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    DescribeInstanceTypesCommandInput,
    DescribeInstanceTypesCommandOutput
  >;
  private serialize;
  private deserialize;
}
