import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  DescribeInstanceTypeOfferingsRequest,
  DescribeInstanceTypeOfferingsResult,
} from "../models/models_3";
export interface DescribeInstanceTypeOfferingsCommandInput
  extends DescribeInstanceTypeOfferingsRequest {}
export interface DescribeInstanceTypeOfferingsCommandOutput
  extends DescribeInstanceTypeOfferingsResult,
    __MetadataBearer {}
export declare class DescribeInstanceTypeOfferingsCommand extends $Command<
  DescribeInstanceTypeOfferingsCommandInput,
  DescribeInstanceTypeOfferingsCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: DescribeInstanceTypeOfferingsCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: DescribeInstanceTypeOfferingsCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    DescribeInstanceTypeOfferingsCommandInput,
    DescribeInstanceTypeOfferingsCommandOutput
  >;
  private serialize;
  private deserialize;
}
