import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  DescribeIdFormatRequest,
  DescribeIdFormatResult,
} from "../models/models_3";
export interface DescribeIdFormatCommandInput extends DescribeIdFormatRequest {}
export interface DescribeIdFormatCommandOutput
  extends DescribeIdFormatResult,
    __MetadataBearer {}
export declare class DescribeIdFormatCommand extends $Command<
  DescribeIdFormatCommandInput,
  DescribeIdFormatCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: DescribeIdFormatCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: DescribeIdFormatCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<DescribeIdFormatCommandInput, DescribeIdFormatCommandOutput>;
  private serialize;
  private deserialize;
}
