import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  DescribeHostReservationsRequest,
  DescribeHostReservationsResult,
} from "../models/models_3";
export interface DescribeHostReservationsCommandInput
  extends DescribeHostReservationsRequest {}
export interface DescribeHostReservationsCommandOutput
  extends DescribeHostReservationsResult,
    __MetadataBearer {}
export declare class DescribeHostReservationsCommand extends $Command<
  DescribeHostReservationsCommandInput,
  DescribeHostReservationsCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: DescribeHostReservationsCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: DescribeHostReservationsCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    DescribeHostReservationsCommandInput,
    DescribeHostReservationsCommandOutput
  >;
  private serialize;
  private deserialize;
}
