import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  DescribeFleetInstancesRequest,
  DescribeFleetInstancesResult,
} from "../models/models_3";
export interface DescribeFleetInstancesCommandInput
  extends DescribeFleetInstancesRequest {}
export interface DescribeFleetInstancesCommandOutput
  extends DescribeFleetInstancesResult,
    __MetadataBearer {}
export declare class DescribeFleetInstancesCommand extends $Command<
  DescribeFleetInstancesCommandInput,
  DescribeFleetInstancesCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: DescribeFleetInstancesCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: DescribeFleetInstancesCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    DescribeFleetInstancesCommandInput,
    DescribeFleetInstancesCommandOutput
  >;
  private serialize;
  private deserialize;
}
