import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  DescribeCustomerGatewaysRequest,
  DescribeCustomerGatewaysResult,
} from "../models/models_3";
export interface DescribeCustomerGatewaysCommandInput
  extends DescribeCustomerGatewaysRequest {}
export interface DescribeCustomerGatewaysCommandOutput
  extends DescribeCustomerGatewaysResult,
    __MetadataBearer {}
export declare class DescribeCustomerGatewaysCommand extends $Command<
  DescribeCustomerGatewaysCommandInput,
  DescribeCustomerGatewaysCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: DescribeCustomerGatewaysCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: DescribeCustomerGatewaysCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    DescribeCustomerGatewaysCommandInput,
    DescribeCustomerGatewaysCommandOutput
  >;
  private serialize;
  private deserialize;
}
