import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  DescribeConversionTasksRequest,
  DescribeConversionTasksResult,
} from "../models/models_3";
export interface DescribeConversionTasksCommandInput
  extends DescribeConversionTasksRequest {}
export interface DescribeConversionTasksCommandOutput
  extends DescribeConversionTasksResult,
    __MetadataBearer {}
export declare class DescribeConversionTasksCommand extends $Command<
  DescribeConversionTasksCommandInput,
  DescribeConversionTasksCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: DescribeConversionTasksCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: DescribeConversionTasksCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    DescribeConversionTasksCommandInput,
    DescribeConversionTasksCommandOutput
  >;
  private serialize;
  private deserialize;
}
