import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  DescribeBundleTasksRequest,
  DescribeBundleTasksResult,
} from "../models/models_3";
export interface DescribeBundleTasksCommandInput
  extends DescribeBundleTasksRequest {}
export interface DescribeBundleTasksCommandOutput
  extends DescribeBundleTasksResult,
    __MetadataBearer {}
export declare class DescribeBundleTasksCommand extends $Command<
  DescribeBundleTasksCommandInput,
  DescribeBundleTasksCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: DescribeBundleTasksCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: DescribeBundleTasksCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<DescribeBundleTasksCommandInput, DescribeBundleTasksCommandOutput>;
  private serialize;
  private deserialize;
}
