import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  DescribeAddressesAttributeRequest,
  DescribeAddressesAttributeResult,
} from "../models/models_3";
export interface DescribeAddressesAttributeCommandInput
  extends DescribeAddressesAttributeRequest {}
export interface DescribeAddressesAttributeCommandOutput
  extends DescribeAddressesAttributeResult,
    __MetadataBearer {}
export declare class DescribeAddressesAttributeCommand extends $Command<
  DescribeAddressesAttributeCommandInput,
  DescribeAddressesAttributeCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: DescribeAddressesAttributeCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: DescribeAddressesAttributeCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    DescribeAddressesAttributeCommandInput,
    DescribeAddressesAttributeCommandOutput
  >;
  private serialize;
  private deserialize;
}
