import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  DeleteVerifiedAccessGroupRequest,
  DeleteVerifiedAccessGroupResult,
} from "../models/models_3";
export interface DeleteVerifiedAccessGroupCommandInput
  extends DeleteVerifiedAccessGroupRequest {}
export interface DeleteVerifiedAccessGroupCommandOutput
  extends DeleteVerifiedAccessGroupResult,
    __MetadataBearer {}
export declare class DeleteVerifiedAccessGroupCommand extends $Command<
  DeleteVerifiedAccessGroupCommandInput,
  DeleteVerifiedAccessGroupCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: DeleteVerifiedAccessGroupCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: DeleteVerifiedAccessGroupCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    DeleteVerifiedAccessGroupCommandInput,
    DeleteVerifiedAccessGroupCommandOutput
  >;
  private serialize;
  private deserialize;
}
