import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  DeleteTrafficMirrorFilterRequest,
  DeleteTrafficMirrorFilterResult,
} from "../models/models_2";
export interface DeleteTrafficMirrorFilterCommandInput
  extends DeleteTrafficMirrorFilterRequest {}
export interface DeleteTrafficMirrorFilterCommandOutput
  extends DeleteTrafficMirrorFilterResult,
    __MetadataBearer {}
export declare class DeleteTrafficMirrorFilterCommand extends $Command<
  DeleteTrafficMirrorFilterCommandInput,
  DeleteTrafficMirrorFilterCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: DeleteTrafficMirrorFilterCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: DeleteTrafficMirrorFilterCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    DeleteTrafficMirrorFilterCommandInput,
    DeleteTrafficMirrorFilterCommandOutput
  >;
  private serialize;
  private deserialize;
}
