import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  DeleteNetworkInsightsAnalysisRequest,
  DeleteNetworkInsightsAnalysisResult,
} from "../models/models_2";
export interface DeleteNetworkInsightsAnalysisCommandInput
  extends DeleteNetworkInsightsAnalysisRequest {}
export interface DeleteNetworkInsightsAnalysisCommandOutput
  extends DeleteNetworkInsightsAnalysisResult,
    __MetadataBearer {}
export declare class DeleteNetworkInsightsAnalysisCommand extends $Command<
  DeleteNetworkInsightsAnalysisCommandInput,
  DeleteNetworkInsightsAnalysisCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: DeleteNetworkInsightsAnalysisCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: DeleteNetworkInsightsAnalysisCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    DeleteNetworkInsightsAnalysisCommandInput,
    DeleteNetworkInsightsAnalysisCommandOutput
  >;
  private serialize;
  private deserialize;
}
