import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  DeleteIpamPoolRequest,
  DeleteIpamPoolResult,
} from "../models/models_2";
export interface DeleteIpamPoolCommandInput extends DeleteIpamPoolRequest {}
export interface DeleteIpamPoolCommandOutput
  extends DeleteIpamPoolResult,
    __MetadataBearer {}
export declare class DeleteIpamPoolCommand extends $Command<
  DeleteIpamPoolCommandInput,
  DeleteIpamPoolCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: DeleteIpamPoolCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: DeleteIpamPoolCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<DeleteIpamPoolCommandInput, DeleteIpamPoolCommandOutput>;
  private serialize;
  private deserialize;
}
