import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import { DeleteFleetsRequest, DeleteFleetsResult } from "../models/models_2";
export interface DeleteFleetsCommandInput extends DeleteFleetsRequest {}
export interface DeleteFleetsCommandOutput
  extends DeleteFleetsResult,
    __MetadataBearer {}
export declare class DeleteFleetsCommand extends $Command<
  DeleteFleetsCommandInput,
  DeleteFleetsCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: DeleteFleetsCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: DeleteFleetsCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<DeleteFleetsCommandInput, DeleteFleetsCommandOutput>;
  private serialize;
  private deserialize;
}
