import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  CreateTrafficMirrorFilterRequest,
  CreateTrafficMirrorFilterResult,
} from "../models/models_2";
export interface CreateTrafficMirrorFilterCommandInput
  extends CreateTrafficMirrorFilterRequest {}
export interface CreateTrafficMirrorFilterCommandOutput
  extends CreateTrafficMirrorFilterResult,
    __MetadataBearer {}
export declare class CreateTrafficMirrorFilterCommand extends $Command<
  CreateTrafficMirrorFilterCommandInput,
  CreateTrafficMirrorFilterCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: CreateTrafficMirrorFilterCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: CreateTrafficMirrorFilterCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    CreateTrafficMirrorFilterCommandInput,
    CreateTrafficMirrorFilterCommandOutput
  >;
  private serialize;
  private deserialize;
}
