import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  CreateNetworkInterfaceRequest,
  CreateNetworkInterfaceResult,
} from "../models/models_1";
export interface CreateNetworkInterfaceCommandInput
  extends CreateNetworkInterfaceRequest {}
export interface CreateNetworkInterfaceCommandOutput
  extends CreateNetworkInterfaceResult,
    __MetadataBearer {}
export declare class CreateNetworkInterfaceCommand extends $Command<
  CreateNetworkInterfaceCommandInput,
  CreateNetworkInterfaceCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: CreateNetworkInterfaceCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: CreateNetworkInterfaceCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    CreateNetworkInterfaceCommandInput,
    CreateNetworkInterfaceCommandOutput
  >;
  private serialize;
  private deserialize;
}
