import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  CreateFlowLogsRequest,
  CreateFlowLogsResult,
} from "../models/models_1";
export interface CreateFlowLogsCommandInput extends CreateFlowLogsRequest {}
export interface CreateFlowLogsCommandOutput
  extends CreateFlowLogsResult,
    __MetadataBearer {}
export declare class CreateFlowLogsCommand extends $Command<
  CreateFlowLogsCommandInput,
  CreateFlowLogsCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: CreateFlowLogsCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: CreateFlowLogsCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<CreateFlowLogsCommandInput, CreateFlowLogsCommandOutput>;
  private serialize;
  private deserialize;
}
