import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  CreateCoipPoolRequest,
  CreateCoipPoolResult,
} from "../models/models_1";
export interface CreateCoipPoolCommandInput extends CreateCoipPoolRequest {}
export interface CreateCoipPoolCommandOutput
  extends CreateCoipPoolResult,
    __MetadataBearer {}
export declare class CreateCoipPoolCommand extends $Command<
  CreateCoipPoolCommandInput,
  CreateCoipPoolCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: CreateCoipPoolCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: CreateCoipPoolCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<CreateCoipPoolCommandInput, CreateCoipPoolCommandOutput>;
  private serialize;
  private deserialize;
}
