import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  CancelCapacityReservationFleetsRequest,
  CancelCapacityReservationFleetsResult,
} from "../models/models_0";
export interface CancelCapacityReservationFleetsCommandInput
  extends CancelCapacityReservationFleetsRequest {}
export interface CancelCapacityReservationFleetsCommandOutput
  extends CancelCapacityReservationFleetsResult,
    __MetadataBearer {}
export declare class CancelCapacityReservationFleetsCommand extends $Command<
  CancelCapacityReservationFleetsCommandInput,
  CancelCapacityReservationFleetsCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: CancelCapacityReservationFleetsCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: CancelCapacityReservationFleetsCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    CancelCapacityReservationFleetsCommandInput,
    CancelCapacityReservationFleetsCommandOutput
  >;
  private serialize;
  private deserialize;
}
