import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import { AttachVolumeRequest, VolumeAttachment } from "../models/models_0";
export interface AttachVolumeCommandInput extends AttachVolumeRequest {}
export interface AttachVolumeCommandOutput
  extends VolumeAttachment,
    __MetadataBearer {}
export declare class AttachVolumeCommand extends $Command<
  AttachVolumeCommandInput,
  AttachVolumeCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: AttachVolumeCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: AttachVolumeCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<AttachVolumeCommandInput, AttachVolumeCommandOutput>;
  private serialize;
  private deserialize;
}
