import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  AssociateSubnetCidrBlockRequest,
  AssociateSubnetCidrBlockResult,
} from "../models/models_0";
export interface AssociateSubnetCidrBlockCommandInput
  extends AssociateSubnetCidrBlockRequest {}
export interface AssociateSubnetCidrBlockCommandOutput
  extends AssociateSubnetCidrBlockResult,
    __MetadataBearer {}
export declare class AssociateSubnetCidrBlockCommand extends $Command<
  AssociateSubnetCidrBlockCommandInput,
  AssociateSubnetCidrBlockCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: AssociateSubnetCidrBlockCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: AssociateSubnetCidrBlockCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    AssociateSubnetCidrBlockCommandInput,
    AssociateSubnetCidrBlockCommandOutput
  >;
  private serialize;
  private deserialize;
}
