import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  AssociateIamInstanceProfileRequest,
  AssociateIamInstanceProfileResult,
} from "../models/models_0";
export interface AssociateIamInstanceProfileCommandInput
  extends AssociateIamInstanceProfileRequest {}
export interface AssociateIamInstanceProfileCommandOutput
  extends AssociateIamInstanceProfileResult,
    __MetadataBearer {}
export declare class AssociateIamInstanceProfileCommand extends $Command<
  AssociateIamInstanceProfileCommandInput,
  AssociateIamInstanceProfileCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: AssociateIamInstanceProfileCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: AssociateIamInstanceProfileCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    AssociateIamInstanceProfileCommandInput,
    AssociateIamInstanceProfileCommandOutput
  >;
  private serialize;
  private deserialize;
}
