import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  AllocateIpamPoolCidrRequest,
  AllocateIpamPoolCidrResult,
} from "../models/models_0";
export interface AllocateIpamPoolCidrCommandInput
  extends AllocateIpamPoolCidrRequest {}
export interface AllocateIpamPoolCidrCommandOutput
  extends AllocateIpamPoolCidrResult,
    __MetadataBearer {}
export declare class AllocateIpamPoolCidrCommand extends $Command<
  AllocateIpamPoolCidrCommandInput,
  AllocateIpamPoolCidrCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: AllocateIpamPoolCidrCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: AllocateIpamPoolCidrCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    AllocateIpamPoolCidrCommandInput,
    AllocateIpamPoolCidrCommandOutput
  >;
  private serialize;
  private deserialize;
}
