import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  AdvertiseByoipCidrRequest,
  AdvertiseByoipCidrResult,
} from "../models/models_0";
export interface AdvertiseByoipCidrCommandInput
  extends AdvertiseByoipCidrRequest {}
export interface AdvertiseByoipCidrCommandOutput
  extends AdvertiseByoipCidrResult,
    __MetadataBearer {}
export declare class AdvertiseByoipCidrCommand extends $Command<
  AdvertiseByoipCidrCommandInput,
  AdvertiseByoipCidrCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: AdvertiseByoipCidrCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: AdvertiseByoipCidrCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<AdvertiseByoipCidrCommandInput, AdvertiseByoipCidrCommandOutput>;
  private serialize;
  private deserialize;
}
