import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  EC2ClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../EC2Client";
import {
  AcceptVpcPeeringConnectionRequest,
  AcceptVpcPeeringConnectionResult,
} from "../models/models_0";
export interface AcceptVpcPeeringConnectionCommandInput
  extends AcceptVpcPeeringConnectionRequest {}
export interface AcceptVpcPeeringConnectionCommandOutput
  extends AcceptVpcPeeringConnectionResult,
    __MetadataBearer {}
export declare class AcceptVpcPeeringConnectionCommand extends $Command<
  AcceptVpcPeeringConnectionCommandInput,
  AcceptVpcPeeringConnectionCommandOutput,
  EC2ClientResolvedConfig
> {
  readonly input: AcceptVpcPeeringConnectionCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: AcceptVpcPeeringConnectionCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: EC2ClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    AcceptVpcPeeringConnectionCommandInput,
    AcceptVpcPeeringConnectionCommandOutput
  >;
  private serialize;
  private deserialize;
}
