import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { StartNetworkInsightsAccessScopeAnalysisRequest, StartNetworkInsightsAccessScopeAnalysisResult } from "../models/models_6";
export interface StartNetworkInsightsAccessScopeAnalysisCommandInput extends StartNetworkInsightsAccessScopeAnalysisRequest {
}
export interface StartNetworkInsightsAccessScopeAnalysisCommandOutput extends StartNetworkInsightsAccessScopeAnalysisResult, __MetadataBearer {
}
/**
 * <p>Starts analyzing the specified Network Access Scope.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, StartNetworkInsightsAccessScopeAnalysisCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, StartNetworkInsightsAccessScopeAnalysisCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const command = new StartNetworkInsightsAccessScopeAnalysisCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link StartNetworkInsightsAccessScopeAnalysisCommandInput} for command's `input` shape.
 * @see {@link StartNetworkInsightsAccessScopeAnalysisCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 */
export declare class StartNetworkInsightsAccessScopeAnalysisCommand extends $Command<StartNetworkInsightsAccessScopeAnalysisCommandInput, StartNetworkInsightsAccessScopeAnalysisCommandOutput, EC2ClientResolvedConfig> {
    readonly input: StartNetworkInsightsAccessScopeAnalysisCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    constructor(input: StartNetworkInsightsAccessScopeAnalysisCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<StartNetworkInsightsAccessScopeAnalysisCommandInput, StartNetworkInsightsAccessScopeAnalysisCommandOutput>;
    private serialize;
    private deserialize;
}
