import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { RevokeSecurityGroupIngressRequest, RevokeSecurityGroupIngressResult } from "../models/models_6";
export interface RevokeSecurityGroupIngressCommandInput extends RevokeSecurityGroupIngressRequest {
}
export interface RevokeSecurityGroupIngressCommandOutput extends RevokeSecurityGroupIngressResult, __MetadataBearer {
}
/**
 * <p>Removes the specified inbound (ingress) rules from a security group.</p>
 *          <p>You can specify rules using either rule IDs or security group rule properties. If you use
 *            rule properties, the values that you specify (for example, ports) must match the existing rule's
 *            values exactly. Each rule has a protocol, from and to ports, and source (CIDR range,
 *            security group, or prefix list). For the TCP and UDP protocols, you must also specify the
 *            destination port or range of ports. For the ICMP protocol, you must also specify the ICMP type
 *            and code. If the security group rule has a description, you do not need to specify the description
 *            to revoke the rule.</p>
 *          <p>[EC2-Classic, default VPC] If the values you specify do not match the existing rule's values, no error is
 *            returned, and the output describes the security group rules that were not revoked.</p>
 *          <p>Amazon Web Services recommends that you describe the security group to verify that the rules were removed.</p>
 *          <p>Rule changes are propagated to instances within the security group as quickly as possible. However, a small delay might occur.</p>
 *          <note>
 *             <p>We are retiring EC2-Classic. We recommend that you migrate from EC2-Classic to a VPC. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-migrate.html">Migrate from EC2-Classic to a VPC</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
 *          </note>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, RevokeSecurityGroupIngressCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, RevokeSecurityGroupIngressCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const command = new RevokeSecurityGroupIngressCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link RevokeSecurityGroupIngressCommandInput} for command's `input` shape.
 * @see {@link RevokeSecurityGroupIngressCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 */
export declare class RevokeSecurityGroupIngressCommand extends $Command<RevokeSecurityGroupIngressCommandInput, RevokeSecurityGroupIngressCommandOutput, EC2ClientResolvedConfig> {
    readonly input: RevokeSecurityGroupIngressCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    constructor(input: RevokeSecurityGroupIngressCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<RevokeSecurityGroupIngressCommandInput, RevokeSecurityGroupIngressCommandOutput>;
    private serialize;
    private deserialize;
}
