import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { ModifyVpcEndpointServicePayerResponsibilityRequest, ModifyVpcEndpointServicePayerResponsibilityResult } from "../models/models_6";
export interface ModifyVpcEndpointServicePayerResponsibilityCommandInput extends ModifyVpcEndpointServicePayerResponsibilityRequest {
}
export interface ModifyVpcEndpointServicePayerResponsibilityCommandOutput extends ModifyVpcEndpointServicePayerResponsibilityResult, __MetadataBearer {
}
/**
 * <p>Modifies the payer responsibility for your VPC endpoint service.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, ModifyVpcEndpointServicePayerResponsibilityCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, ModifyVpcEndpointServicePayerResponsibilityCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const command = new ModifyVpcEndpointServicePayerResponsibilityCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link ModifyVpcEndpointServicePayerResponsibilityCommandInput} for command's `input` shape.
 * @see {@link ModifyVpcEndpointServicePayerResponsibilityCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 */
export declare class ModifyVpcEndpointServicePayerResponsibilityCommand extends $Command<ModifyVpcEndpointServicePayerResponsibilityCommandInput, ModifyVpcEndpointServicePayerResponsibilityCommandOutput, EC2ClientResolvedConfig> {
    readonly input: ModifyVpcEndpointServicePayerResponsibilityCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    constructor(input: ModifyVpcEndpointServicePayerResponsibilityCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<ModifyVpcEndpointServicePayerResponsibilityCommandInput, ModifyVpcEndpointServicePayerResponsibilityCommandOutput>;
    private serialize;
    private deserialize;
}
