import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { ModifyVerifiedAccessInstanceRequest, ModifyVerifiedAccessInstanceResult } from "../models/models_6";
export interface ModifyVerifiedAccessInstanceCommandInput extends ModifyVerifiedAccessInstanceRequest {
}
export interface ModifyVerifiedAccessInstanceCommandOutput extends ModifyVerifiedAccessInstanceResult, __MetadataBearer {
}
/**
 * <p>Modifies the configuration of the specified Verified Access instance.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, ModifyVerifiedAccessInstanceCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, ModifyVerifiedAccessInstanceCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const command = new ModifyVerifiedAccessInstanceCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link ModifyVerifiedAccessInstanceCommandInput} for command's `input` shape.
 * @see {@link ModifyVerifiedAccessInstanceCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 */
export declare class ModifyVerifiedAccessInstanceCommand extends $Command<ModifyVerifiedAccessInstanceCommandInput, ModifyVerifiedAccessInstanceCommandOutput, EC2ClientResolvedConfig> {
    readonly input: ModifyVerifiedAccessInstanceCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    constructor(input: ModifyVerifiedAccessInstanceCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<ModifyVerifiedAccessInstanceCommandInput, ModifyVerifiedAccessInstanceCommandOutput>;
    private serialize;
    private deserialize;
}
