import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { ModifySpotFleetRequestRequest, ModifySpotFleetRequestResponse } from "../models/models_6";
export interface ModifySpotFleetRequestCommandInput extends ModifySpotFleetRequestRequest {
}
export interface ModifySpotFleetRequestCommandOutput extends ModifySpotFleetRequestResponse, __MetadataBearer {
}
/**
 * <p>Modifies the specified Spot Fleet request.</p>
 *          <p>You can only modify a Spot Fleet request of type <code>maintain</code>.</p>
 *          <p>While the Spot Fleet request is being modified, it is in the <code>modifying</code>
 *             state.</p>
 *          <p>To scale up your Spot Fleet, increase its target capacity. The Spot Fleet launches the
 *             additional Spot Instances according to the allocation strategy for the Spot Fleet
 *             request. If the allocation strategy is <code>lowestPrice</code>, the Spot Fleet launches
 *             instances using the Spot Instance pool with the lowest price. If the allocation strategy
 *             is <code>diversified</code>, the Spot Fleet distributes the instances across the Spot
 *             Instance pools. If the allocation strategy is <code>capacityOptimized</code>, Spot Fleet
 *             launches instances from Spot Instance pools with optimal capacity for the number of instances
 *             that are launching.</p>
 *          <p>To scale down your Spot Fleet, decrease its target capacity. First, the Spot Fleet
 *             cancels any open requests that exceed the new target capacity. You can request that the
 *             Spot Fleet terminate Spot Instances until the size of the fleet no longer exceeds the
 *             new target capacity. If the allocation strategy is <code>lowestPrice</code>, the Spot
 *             Fleet terminates the instances with the highest price per unit. If the allocation
 *             strategy is <code>capacityOptimized</code>, the Spot Fleet terminates the instances in
 *             the Spot Instance pools that have the least available Spot Instance capacity. If the allocation
 *             strategy is <code>diversified</code>, the Spot Fleet terminates instances across the
 *             Spot Instance pools. Alternatively, you can request that the Spot Fleet keep the fleet
 *             at its current size, but not replace any Spot Instances that are interrupted or that you
 *             terminate manually.</p>
 *          <p>If you are finished with your Spot Fleet for now, but will use it again later, you can
 *             set the target capacity to 0.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, ModifySpotFleetRequestCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, ModifySpotFleetRequestCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const command = new ModifySpotFleetRequestCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link ModifySpotFleetRequestCommandInput} for command's `input` shape.
 * @see {@link ModifySpotFleetRequestCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 */
export declare class ModifySpotFleetRequestCommand extends $Command<ModifySpotFleetRequestCommandInput, ModifySpotFleetRequestCommandOutput, EC2ClientResolvedConfig> {
    readonly input: ModifySpotFleetRequestCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    constructor(input: ModifySpotFleetRequestCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<ModifySpotFleetRequestCommandInput, ModifySpotFleetRequestCommandOutput>;
    private serialize;
    private deserialize;
}
