import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { GetNetworkInsightsAccessScopeContentRequest, GetNetworkInsightsAccessScopeContentResult } from "../models/models_5";
export interface GetNetworkInsightsAccessScopeContentCommandInput extends GetNetworkInsightsAccessScopeContentRequest {
}
export interface GetNetworkInsightsAccessScopeContentCommandOutput extends GetNetworkInsightsAccessScopeContentResult, __MetadataBearer {
}
/**
 * <p>Gets the content for the specified Network Access Scope.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, GetNetworkInsightsAccessScopeContentCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, GetNetworkInsightsAccessScopeContentCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const command = new GetNetworkInsightsAccessScopeContentCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link GetNetworkInsightsAccessScopeContentCommandInput} for command's `input` shape.
 * @see {@link GetNetworkInsightsAccessScopeContentCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 */
export declare class GetNetworkInsightsAccessScopeContentCommand extends $Command<GetNetworkInsightsAccessScopeContentCommandInput, GetNetworkInsightsAccessScopeContentCommandOutput, EC2ClientResolvedConfig> {
    readonly input: GetNetworkInsightsAccessScopeContentCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    constructor(input: GetNetworkInsightsAccessScopeContentCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<GetNetworkInsightsAccessScopeContentCommandInput, GetNetworkInsightsAccessScopeContentCommandOutput>;
    private serialize;
    private deserialize;
}
