import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { GetIpamResourceCidrsRequest, GetIpamResourceCidrsResult } from "../models/models_5";
export interface GetIpamResourceCidrsCommandInput extends GetIpamResourceCidrsRequest {
}
export interface GetIpamResourceCidrsCommandOutput extends GetIpamResourceCidrsResult, __MetadataBearer {
}
/**
 * <p>Get information about the resources in a scope.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, GetIpamResourceCidrsCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, GetIpamResourceCidrsCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const command = new GetIpamResourceCidrsCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link GetIpamResourceCidrsCommandInput} for command's `input` shape.
 * @see {@link GetIpamResourceCidrsCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 */
export declare class GetIpamResourceCidrsCommand extends $Command<GetIpamResourceCidrsCommandInput, GetIpamResourceCidrsCommandOutput, EC2ClientResolvedConfig> {
    readonly input: GetIpamResourceCidrsCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    constructor(input: GetIpamResourceCidrsCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<GetIpamResourceCidrsCommandInput, GetIpamResourceCidrsCommandOutput>;
    private serialize;
    private deserialize;
}
