import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { GetIpamPoolAllocationsRequest, GetIpamPoolAllocationsResult } from "../models/models_5";
export interface GetIpamPoolAllocationsCommandInput extends GetIpamPoolAllocationsRequest {
}
export interface GetIpamPoolAllocationsCommandOutput extends GetIpamPoolAllocationsResult, __MetadataBearer {
}
/**
 * <p>Get a list of all the CIDR allocations in an IPAM pool.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, GetIpamPoolAllocationsCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, GetIpamPoolAllocationsCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const command = new GetIpamPoolAllocationsCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link GetIpamPoolAllocationsCommandInput} for command's `input` shape.
 * @see {@link GetIpamPoolAllocationsCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 */
export declare class GetIpamPoolAllocationsCommand extends $Command<GetIpamPoolAllocationsCommandInput, GetIpamPoolAllocationsCommandOutput, EC2ClientResolvedConfig> {
    readonly input: GetIpamPoolAllocationsCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    constructor(input: GetIpamPoolAllocationsCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<GetIpamPoolAllocationsCommandInput, GetIpamPoolAllocationsCommandOutput>;
    private serialize;
    private deserialize;
}
