import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { EnableReachabilityAnalyzerOrganizationSharingRequest, EnableReachabilityAnalyzerOrganizationSharingResult } from "../models/models_5";
export interface EnableReachabilityAnalyzerOrganizationSharingCommandInput extends EnableReachabilityAnalyzerOrganizationSharingRequest {
}
export interface EnableReachabilityAnalyzerOrganizationSharingCommandOutput extends EnableReachabilityAnalyzerOrganizationSharingResult, __MetadataBearer {
}
/**
 * <p>Establishes a trust relationship between Reachability Analyzer and Organizations.
 *          This operation must be performed by the management account for the organization.</p>
 *          <p>After you establish a trust relationship, a user in the management account or
 *          a delegated administrator account can run a cross-account analysis using resources
 *          from the member accounts.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, EnableReachabilityAnalyzerOrganizationSharingCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, EnableReachabilityAnalyzerOrganizationSharingCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const command = new EnableReachabilityAnalyzerOrganizationSharingCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link EnableReachabilityAnalyzerOrganizationSharingCommandInput} for command's `input` shape.
 * @see {@link EnableReachabilityAnalyzerOrganizationSharingCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 */
export declare class EnableReachabilityAnalyzerOrganizationSharingCommand extends $Command<EnableReachabilityAnalyzerOrganizationSharingCommandInput, EnableReachabilityAnalyzerOrganizationSharingCommandOutput, EC2ClientResolvedConfig> {
    readonly input: EnableReachabilityAnalyzerOrganizationSharingCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    constructor(input: EnableReachabilityAnalyzerOrganizationSharingCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<EnableReachabilityAnalyzerOrganizationSharingCommandInput, EnableReachabilityAnalyzerOrganizationSharingCommandOutput>;
    private serialize;
    private deserialize;
}
