import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { EnableFastLaunchRequest, EnableFastLaunchResult } from "../models/models_5";
export interface EnableFastLaunchCommandInput extends EnableFastLaunchRequest {
}
export interface EnableFastLaunchCommandOutput extends EnableFastLaunchResult, __MetadataBearer {
}
/**
 * <p>When you enable faster launching for a Windows AMI, images are pre-provisioned,
 * 			using snapshots to launch instances up to 65% faster. To create the optimized Windows
 * 			image, Amazon EC2 launches an instance and runs through Sysprep steps, rebooting as required.
 * 			Then it creates a set of reserved snapshots that are used for subsequent launches. The
 * 			reserved snapshots are automatically replenished as they are used, depending on your
 * 			settings for launch frequency.</p>
 *          <note>
 *             <p>To change these settings, you must own the AMI.</p>
 *          </note>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, EnableFastLaunchCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, EnableFastLaunchCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const command = new EnableFastLaunchCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link EnableFastLaunchCommandInput} for command's `input` shape.
 * @see {@link EnableFastLaunchCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 */
export declare class EnableFastLaunchCommand extends $Command<EnableFastLaunchCommandInput, EnableFastLaunchCommandOutput, EC2ClientResolvedConfig> {
    readonly input: EnableFastLaunchCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    constructor(input: EnableFastLaunchCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<EnableFastLaunchCommandInput, EnableFastLaunchCommandOutput>;
    private serialize;
    private deserialize;
}
